package com.ejie.ab04b.evento;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesPlateaTramitacion;
import com.ejie.ab04b.constantes.EstadosTareas;
import com.ejie.ab04b.constantes.TipoDocumentoEnum;
import com.ejie.ab04b.constantes.TipoTareaFlujo;
import com.ejie.ab04b.constantes.TipoTareaPlatea;
import com.ejie.ab04b.constantes.TipoTramiteFlujo;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.exception.AB04BParseException;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.ComunicacionProcedimiento;
import com.ejie.ab04b.model.DocumentoAperturas;
import com.ejie.ab04b.model.Tarea;
import com.ejie.ab04b.model.TareaAperturas;
import com.ejie.ab04b.model.TareaProcedimiento;
import com.ejie.ab04b.model.TipoDocumento;
import com.ejie.ab04b.model.Tramite;
import com.ejie.ab04b.model.TramiteAperturas;
import com.ejie.ab04b.model.TramiteProcedimiento;
import com.ejie.ab04b.service.ComunicacionAperturaService;
import com.ejie.ab04b.service.DocumentoAperturasService;
import com.ejie.ab04b.service.TareaAperturasService;
import com.ejie.ab04b.service.TareaService;
import com.ejie.ab04b.service.TramiteAperturasService;
import com.ejie.ab04b.service.TramiteService;
import com.ejie.ab04b.service.pif.PifService;
import com.ejie.ab04b.service.tramitacion.TramitacionAperturasService;
import com.ejie.ab04b.util.PlateaTramitacionUtils;
import com.ejie.ab04b.util.PropertiesUtil;
import com.ejie.ab04b.util.Utilities;
import com.ejie.foldermanagement.xml.ContextSubmissionEvent;
import com.ejie.foldermanagement.xml.DocumentsEvent;
import com.ejie.mbt.xml.Task;

/**
 * @author GFI-NORTE
 *
 */
/**
 * @author GFI-NORTE
 * 
 */
@Service(value = "manejadorTareasAperturas")
public class ManejadorTareasAperturas implements ManejadorTareas {

	private static final Logger LOGGER = LoggerFactory
			.getLogger(ManejadorTareasAperturas.class);

	@Autowired()
	private ComunicacionAperturaService comunicacionAperturaService;
	@Autowired()
	private TramiteAperturasService tramiteAperturasService;
	@Autowired()
	private TareaAperturasService tareaAperturasService;
	@Autowired()
	private DocumentoAperturasService documentoAperturasService;
	@Autowired()
	private TramiteService tramiteService;

	@Autowired()
	private TramitacionAperturasService tramitacionAperturasService;

	@Autowired()
	private TareaService tareaService;
	@Autowired()
	private PifService pifService;
	@Autowired()
	private Properties appConfiguration;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.evento.ManejadorTareas#getDocCorrExpedienteByFolderId(
	 * java.lang.String)
	 */
	@Override()
	public String getDocCorrExpedienteByFolderId(String folderId) {

		return this.comunicacionAperturaService.findByFolderId(folderId)
				.getDoccorrecta056();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.evento.ManejadorTareas#obtenerFolderNumberByFolderId(java
	 * .lang.String)
	 */
	@Override()
	public String obtenerFolderNumberByFolderId(String folderId) {
		ComunicacionApertura apertura = this.comunicacionAperturaService
				.findByFolderId2(folderId);

		if (apertura != null) {
			return apertura.getNumExpediente();
		} else {
			return null;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.evento.ManejadorTareas#findExpedienteByFolderId(java.lang
	 * .String)
	 */
	@Override()
	public ComunicacionApertura findExpedienteByFolderId(String folderId) {

		return this.comunicacionAperturaService.findByFolderId(folderId);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.evento.ManejadorTareas#getTerritorioExpedienteByFolderId
	 * (java.lang.String)
	 */
	@Override()
	public String getTerritorioExpedienteByFolderId(String folderId) {

		// ComunicacionApertura apertura =
		// this.findExpedienteByFolderId(folderId);
		ComunicacionApertura apertura = this.comunicacionAperturaService
				.findByFolderId2(folderId);
		return apertura.getTerape056();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.evento.ManejadorTareas#crearTramiteTareaSugerida(com.ejie
	 * .mbt.xml.Task, com.ejie.ab04b.model.Tarea)
	 */
	@Override()
	public TramiteProcedimiento crearTramiteTareaSugerida(Task task,
			Tarea tipoTarea) {

		// Obtenemos el expediente de aperturas
		ComunicacionApertura apertura = this.comunicacionAperturaService
				.findByFolderId(task.getFolderID());

		TramiteAperturas tramite = new TramiteAperturas();
		tramite.setTipoTramite(tipoTarea.getTramite());
		tramite.setApertura(apertura);

		tramite = this.tramiteAperturasService.add(tramite);

		return tramite;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.evento.ManejadorTareas#crearTareaSugerida(com.ejie.mbt
	 * .xml.Task, com.ejie.ab04b.model.Tarea,
	 * com.ejie.ab04b.model.TramiteProcedimiento)
	 */
	@Override()
	public TareaProcedimiento crearTareaSugerida(Task task, Tarea tipoTarea,
			TramiteProcedimiento tramite) {

		TareaAperturas tarea = new TareaAperturas();
		tarea.setTramiteAperturas((TramiteAperturas) tramite);
		tarea.setMailboxTaskId063(task.getMailboxTaskID());
		tarea.setTipoTarea(tipoTarea);
		tarea.setEstado063(EstadosTareas.SUGERIDA.getEstado());
		tarea.setFechaIni063(PlateaTramitacionUtils.getInstance()
				.parsearTimestampPlatea(task.getDoTimestamp()));

		tarea = this.tareaAperturasService.add(tarea);

		return tarea;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.evento.ManejadorTareas#crearExpediente(java.lang.String,
	 * com.ejie.foldermanagement.xml.ContextSubmissionEvent)
	 */
	@Override()
	public void crearExpediente(String sdetailInfo,
			ContextSubmissionEvent contextSubmission)
			throws AB04BParseException {

		/*
		 * DetailInfo detailInfo = DetailInfoParser.getInstance()
		 * .getDetailInfoAperturasSolTel(sdetailInfo);
		 */
		// TODO metemos folderId de prueba
		// contextSubmission.setFolderID("99999");
		/*
		 * this.comunicacionAperturaService
		 * .insertarComunicacionAperturaContextSubmission(contextSubmission);
		 */
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.evento.ManejadorTareas#actualizarTareaEjecutada(com.ejie
	 * .mbt.xml.Task)
	 */
	@Override()
	public void actualizarTareaEjecutada(Task task) throws AB04BException {
		ComunicacionApertura apertura = this.comunicacionAperturaService
				.findByFolderId(task.getFolderID());

		Tarea tipoTarea = this.tareaService.findByTaskIdProcedureId(
				task.getTaskID(), task.getProcedureID());

		if (tipoTarea == null) {
			throw new AB04BException("JMS Procesado antes de tiempo.");
		}

		if (tipoTarea.getEsInicial090() && TipoTareaPlatea.APERTURA.name()
				.equalsIgnoreCase(tipoTarea.getTaskId090())) {
			// try {
			// Thread.sleep(ConstantesNum.NUM_5000);
			// } catch (InterruptedException e) {
			// ManejadorTareasAperturas.LOGGER.error(
			// "[ERROR] : Fallo en actualizarTareaEjecutada sleep");
			// }
		} else {
			// try {
			// Thread.sleep(ConstantesNum.NUM_3000);
			// } catch (InterruptedException e) {
			// ManejadorTareasAperturas.LOGGER.error(
			// "[ERROR] : Fallo en actualizarTareaEjecutada en sleep");
			// }
		}

		TareaAperturas tarea = this.tareaAperturasService
				.findByMailboxTaskId(task.getMailboxTaskID());
		tarea.setEstado063(EstadosTareas.EJECUTADA.getEstado());

		if (Constantes.AUTOMATICA.equals(tarea.getTipoTarea().getTipo090())
				&& !TipoTareaPlatea.APERTURA.name()
						.equalsIgnoreCase(tipoTarea.getTaskId090())) {

			tarea.setUsuario063(task.getSenderID());

		} else if (TipoTareaPlatea.APERTURA.name()
				.equalsIgnoreCase(tipoTarea.getTaskId090())) {
			tarea.setUsuario063(apertura.getUsuarioApe());
		}

		if (apertura.getUsuarioTram() == null
				&& apertura.getUsuarioApe() != null) {
			tarea.setUsuario063(apertura.getUsuarioApe());
		} else {
			tarea.setUsuario063(apertura.getUsuarioTram());
		}

		if (!TipoTramiteFlujo.APERTURA.name().equalsIgnoreCase(
				tipoTarea.getTramite().getProceedingId089())) {

			if ((TipoTramiteFlujo.REQUERIMIENTO.name().equalsIgnoreCase(
					tipoTarea.getTramite().getProceedingId089())
					|| TipoTramiteFlujo.COMUNICACION_OS2.name()
							.equalsIgnoreCase(
									tipoTarea.getTramite().getProceedingId089())
					|| TipoTramiteFlujo.COMUNICACION_OS2OS3.name()
							.equalsIgnoreCase(tipoTarea.getTramite()
									.getProceedingId089()))
					&& "S".equals(apertura.getDoccorrecta056())) {
				tarea.setUsuario063(apertura.getUsuarioApe());
			} else {
				tarea.setUsuario063(apertura.getUsuarioTram());
			}
		}

		// TODO la fecha endTimestamp no llega siempre. No sabemos por qué
		tarea.setFechaFin063(
				PlateaTramitacionUtils.getInstance()
						.parsearTimestampPlatea(task.getEndTimestamp() != null
								? task.getEndTimestamp()
								: task.getDoTimestamp()));

		this.tareaAperturasService.updateFilled(tarea);

		// Si es la tarea de cierre del expediente
		if (task.getTaskID().equals(TipoTareaFlujo.CIERRE.getTaskId())) {

			if (!Constantes.ESTADO_ELIMINADO.equals(apertura.getEstado056())) {
				this.comunicacionAperturaService.updateCierre(apertura);
			}

		} else if (task.getTaskID()
				.equals(TipoTareaFlujo.REGISTRA_INFORME_ENTRADA.getTaskId())) {

			apertura.setFinfosl056(new Date());
			this.comunicacionAperturaService.update(apertura);
		} else if (TipoTramiteFlujo.REQUERIMIENTO.name().equalsIgnoreCase(
				tipoTarea.getTramite().getProceedingId089())) {
			apertura.setFecreq056(new Date());
			apertura.setFecsub056(null);
			this.comunicacionAperturaService.update(apertura);
			this.comunicacionAperturaService.updateBatchSub(apertura);
		}

		if (tipoTarea.getEsInicial090() && TipoTareaPlatea.APERTURA.name()
				.equalsIgnoreCase(tipoTarea.getTaskId090())) {
			apertura.setEstado056("A");
			this.comunicacionAperturaService.updateFilled(apertura);
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.evento.ManejadorTareas#obtenerTramitePadreExistente(com
	 * .ejie.ab04b.model.Tarea, com.ejie.ab04b.model.ComunicacionProcedimiento)
	 */
	@Override()
	public TramiteProcedimiento obtenerTramitePadreExistente(Tarea tarea,
			ComunicacionProcedimiento comunicacion) {

		ComunicacionApertura apertura = (ComunicacionApertura) comunicacion;

		return this.tramiteAperturasService.findLastTramiteByTipo(
				tarea.getTramite().getIdTramite089(), apertura);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.evento.ManejadorTareas#ejecutarTareaAutomatica(com.ejie
	 * .ab04b.model.TareaProcedimiento)
	 */
	@Override()
	public void ejecutarTareaAutomatica(TareaProcedimiento tareaGenerica)
			throws AB04BException {
		try {

			TareaAperturas tarea = (TareaAperturas) tareaGenerica;

			String taskId = tarea.getTipoTarea().getTaskId090();

			// Estas tareas vienen por aquí porque al adjuntar un documento, hay
			// una
			// transformación a PDFA (con espera), por lo que no podemos hacer
			// uso
			// de la etiqueta <processUrl> del flujo
			if (TipoTareaFlujo.ADJUNTAR_DOC_REQUERIMIENTO
					.esEquivalente(taskId)) {
				this.tramitacionAperturasService
						.prepararDocRequerimiento(tarea);

			} else if (TipoTareaFlujo.ADJUNTAR_CARTA_CONTRATISTA
					.esEquivalente(taskId)) {
				this.tramitacionAperturasService
						.prepararDocCartaContratista(tarea);

			} else if (TipoTareaFlujo.ADJUNTAR_COMUNICACION_OS2
					.esEquivalente(taskId)) {
				this.tramitacionAperturasService
						.prepararDocComunicacionOS2(tarea);

			} else if (TipoTareaFlujo.ADJUNTAR_COMUNICACION_OS3
					.esEquivalente(taskId)) {
				this.tramitacionAperturasService
						.prepararDocComunicacionOS3(tarea);

			} else if (TipoTareaFlujo.ADJUNTAR_CARTA_CAMBIO_COORDINADOR_CONTRATISTA
					.esEquivalente(taskId)) {
				this.tramitacionAperturasService
						.prepararDocCartaCambioCoordinador(tarea);

			} else if (TipoTareaFlujo.REGISTRA_INFORME_SALIDA
					.esEquivalente(taskId)) {

				DocumentoAperturas documento = new DocumentoAperturas();
				documento.setTramiteAperturas(new TramiteAperturas(
						tarea.getTramiteAperturas().getIdTramite062()));
				documento.setTipoDocumento(new TipoDocumento(
						TipoDocumentoEnum.INFORME_VISITA_OSALAN
								.getIdTipoDoc()));
				documento = this.documentoAperturasService
						.findByTramite(documento);

				this.tramitacionAperturasService.tramitarRegistrarDoc(tarea,
						documento);

			} else if (TipoTareaFlujo.REGISTRA_INFORME_ENTRADA
					.esEquivalente(taskId)) {

				DocumentoAperturas documento = new DocumentoAperturas();
				documento.setTramiteAperturas(new TramiteAperturas(
						tarea.getTramiteAperturas().getIdTramite062()));
				documento.setTipoDocumento(new TipoDocumento(
						TipoDocumentoEnum.INFORME_VISITA_OSALAN
								.getIdTipoDoc()));
				documento = this.documentoAperturasService
						.findByTramite(documento);

				this.tramitacionAperturasService.tramitarRegistrarDoc(tarea,
						documento);

			} else if (TipoTareaFlujo.ACUSE_REQUERIMIENTO_POSTAL
					.esEquivalente(taskId)) {

				TramiteAperturas tramite = this.obtenerTramiteAperturas(tarea);

				this.tramitacionAperturasService
						.tramitarAcuseRequerimiento(tarea, tramite);

			} else if (TipoTareaFlujo.ADJUNTAR_INFORME_INSPECCION
					.esEquivalente(taskId)) {

				List<DocumentoAperturas> listaDocumentos = this
						.copiarDocsT65e(tarea.getTramiteAperturas()
								.getApertura().getIdape056());

				this.tramitacionAperturasService
						.prepararDocAdjuntarInformeInspeccion(tarea,
								listaDocumentos.get(0));
			}

			tarea.setEstado063(EstadosTareas.INICIADA.getEstado());
			this.tareaAperturasService.updateFilled(tarea);
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab04b.evento.ManejadorTareas#
	 * continuarEjecucionTareaEsperaTransformacion(java.lang.Long,
	 * java.lang.Long)
	 */
	@Override()
	public void continuarEjecucionTareaEsperaTransformacion(Long idTarea,
			Long idDocumento) {

		TareaAperturas tarea = this.tareaAperturasService
				.find(new TareaAperturas(idTarea));

		DocumentoAperturas documento = this.documentoAperturasService
				.find(new DocumentoAperturas(idDocumento));

		// Antes de continuar, cambiamos el nombre al documento para ponerle
		// extensión PDF
		String extension = Utilities.getInstance()
				.obtenerExtensionFichero(documento.getNombreDoc065());
		if (extension != null) {
			String nomFichero = documento.getNombreDoc065();
			nomFichero = nomFichero.substring(0,
					nomFichero.length() - extension.length());
			nomFichero = nomFichero.concat(Constantes.EXT_PDF);
			documento.setNombreDoc065(nomFichero);

			this.documentoAperturasService.updateFilled(documento);
		}

		String taskId = tarea.getTipoTarea().getTaskId090();
		try {
			if (TipoTareaFlujo.ADJUNTAR_DOC_REQUERIMIENTO.esEquivalente(taskId)
					|| TipoTareaFlujo.ADJUNTAR_CARTA_CONTRATISTA
							.esEquivalente(taskId)
					|| TipoTareaFlujo.ADJUNTAR_COMUNICACION_OS2
							.esEquivalente(taskId)
					|| TipoTareaFlujo.ADJUNTAR_COMUNICACION_OS3
							.esEquivalente(taskId)
					|| TipoTareaFlujo.ADJUNTAR_CARTA_CAMBIO_COORDINADOR_CONTRATISTA
							.esEquivalente(taskId)
					|| TipoTareaFlujo.ADJUNTAR_INFORME.esEquivalente(taskId)
					|| TipoTareaFlujo.ADJUNTAR_INFORME_INSPECCION
							.esEquivalente(taskId)) {
				this.tramitacionAperturasService.tramitarAdjuntarDoc(tarea,
						documento);
			}
		} catch (Exception e) {
			ManejadorTareasAperturas.LOGGER.error("ERROR EN MANEJADOR");
			e.getCause();
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.evento.ManejadorTareas#processEnviarNotificacion(com.ejie
	 * .mbt.xml.Task)
	 */
	@Override()
	public void processEnviarNotificacion(Task task) throws AB04BException {
		TareaAperturas tarea = null;

		try {

			int contador = 0;

			// intentamos 3 veces recuperar la solicitud por si no le ha dado
			// tiempo a guardar

			while (contador < 3 && tarea == null) {

				contador++;

				tarea = this.obtenerTareaAperturas(task.getMailboxTaskID());

				if (tarea == null) {

					TimeUnit.SECONDS.sleep(2);

				}

			}

			if (contador == 3) {

				throw new AB04BException("No existe tarea con mailboxtaskid: "
						+ task.getMailboxTaskID());

			}
		} catch (Exception e) {
			throw new AB04BException("Error: " + e.getMessage());
		}

		TramiteAperturas tramite = this.obtenerTramiteAperturas(tarea);

		TipoTramiteFlujo tipoTramite = TipoTramiteFlujo
				.valueOf(tramite.getTipoTramite().getProceedingId089());

		this.tramitacionAperturasService.processEnviarNotificacion(task,
				tramite, tarea, tipoTramite);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.evento.ManejadorTareas#processRegistrarComunicacionPostal
	 * (com.ejie.mbt.xml.Task)
	 */
	@Override()
	public void processRegistrarComunicacionPostal(Task task) throws Exception {

		TareaAperturas tarea = null;

		try {

			int contador = 0;

			// intentamos 3 veces recuperar la solicitud por si no le ha dado
			// tiempo a guardar

			while (contador < 3 && tarea == null) {

				contador++;

				tarea = this.obtenerTareaAperturas(task.getMailboxTaskID());

				if (tarea == null) {

					TimeUnit.SECONDS.sleep(2);

				}

			}

			if (contador == 3) {

				throw new AB04BException("No existe tarea con mailboxtaskid: "
						+ task.getMailboxTaskID());

			}
		} catch (Exception e) {
			throw new AB04BException("Error: " + e.getMessage());
		}

		TramiteAperturas tramite = this.obtenerTramiteAperturas(tarea);

		TipoTramiteFlujo tipoTramite = TipoTramiteFlujo
				.valueOf(tramite.getTipoTramite().getProceedingId089());

		this.tramitacionAperturasService.processRegistrarComunicacionPostal(
				task, tramite, tarea, tipoTramite);
	}

	/**
	 * Obtener tarea aperturas.
	 * 
	 * mailboxTaskId String TareaAperturas
	 *
	 * @param mailboxTaskId
	 *            the mailbox task id
	 * @return the tarea aperturas
	 */
	private TareaAperturas obtenerTareaAperturas(String mailboxTaskId) {

		return this.tareaAperturasService.findByMailboxTaskId(mailboxTaskId);
	}

	/**
	 * Obtener tramite aperturas.
	 * 
	 * tarea TareaAperturas TramiteAperturas
	 *
	 * @param tarea
	 *            the tarea
	 * @return the tramite aperturas
	 */
	private TramiteAperturas obtenerTramiteAperturas(TareaAperturas tarea) {

		TramiteAperturas tramite = this.tramiteAperturasService
				.find(tarea.getTramiteAperturas());
		tramite.setTipoTramite(
				this.tramiteService.find(tramite.getTipoTramite()));

		return tramite;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.evento.ManejadorTareas#generarYObtenerIdTramiteApertura
	 * (com.ejie.foldermanagement.xml.ContextSubmissionEvent)
	 */
	@Override()
	public Long generarYObtenerIdTramiteApertura(
			ContextSubmissionEvent contextSubmission) throws AB04BException {

		// try {
		// Thread.sleep(ConstantesNum.NUM_2000);
		// } catch (InterruptedException e) {
		// ManejadorTareasAperturas.LOGGER.error(
		// "[ERROR] : Fallo en generarYObtenerIdTramiteApertura sleep");
		// }

		// Obtenemos la comunicación de aperturas
		ComunicacionApertura apertura = this
				.findExpedienteByFolderId(contextSubmission.getFolderID());

		if (apertura == null) {
			throw new AB04BException("JMS Procesado antes de tiempo.");
		}

		apertura.setUsuarioApe(contextSubmission.getRegistrySenderID());

		this.comunicacionAperturaService.updateUsuariosTramitacion(apertura);

		// Obtenemos el tipo de trámite de apertura
		Tramite tipoTramiteApertura = this.tramiteService
				.findByProceedingIdProcedureId(TipoTramiteFlujo.APERTURA.name(),
						Utilities.getInstance().obtenerProcedureIdApertura());

		// Creamos el trámite de apertura para el expediente
		TramiteAperturas tramiteApertura = new TramiteAperturas();
		tramiteApertura
				.setNumRegistro062(contextSubmission.getRegistryNumber());
		try {
			tramiteApertura.setFecRegistro062(
					Utilities.getInstance().stringToDatePlatea(
							contextSubmission.getRegistryTimestamp()));
		} catch (Exception e) {
			ManejadorTareasAperturas.LOGGER.error(
					"[ERROR] : Fallo en generarYObtenerIdTramiteApertura: contextSubmission.getRegistryTimestamp()");
		}
		tramiteApertura.setTipoTramite(tipoTramiteApertura);
		tramiteApertura.setApertura(apertura);
		tramiteApertura = this.tramiteAperturasService.add(tramiteApertura);

		return tramiteApertura.getIdTramite062();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.evento.ManejadorTareas#guardarDocumentosSolicitud(com.
	 * ejie.foldermanagement.xml.DocumentsEvent, java.lang.String,
	 * java.lang.Long)
	 */
	@Override()
	public void guardarDocumentosSolicitud(DocumentsEvent documents,
			String fechaCreacion, Long idTramite) {

		this.documentoAperturasService.addDocumentosSolicitud(
				documents.getDocumentEvent(), fechaCreacion, idTramite);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab04b.evento.ManejadorTareas#
	 * generarYObtenerIdTramiteYTareaAportacion
	 * (com.ejie.foldermanagement.xml.ContextSubmissionEvent)
	 */
	@Override()
	public Long generarYObtenerIdTramiteYTareaAportacion(
			ContextSubmissionEvent contextSubmission) {

		// Obtenemos la comunicación de aperturas
		ComunicacionApertura apertura = this
				.findExpedienteByFolderId(contextSubmission.getFolderID());

		apertura.setFecsub056(new Date());
		this.comunicacionAperturaService.updateFecSub(apertura);

		apertura.setUsuarioAport(contextSubmission.getRegistrySenderID());

		this.comunicacionAperturaService.updateUsuariosTramitacion(apertura);

		// Mirar si se trata de una aportacion genérica o una subsanación
		String tipotramite = TipoTramiteFlujo.APORTACION_DOCUMENTACION.name();
		if (ConstantesPlateaTramitacion.SUBMISSIONTYPE_APORT_SUBSANA
				.equals(contextSubmission.getSubmissionType())) {
			tipotramite = TipoTramiteFlujo.SUBSANACION.name();
		}
		// Obtenemos el tipo de trámite de apertura
		Tramite tipoTramiteApertura = this.tramiteService
				.findByProceedingIdProcedureId(tipotramite,
						Utilities.getInstance().obtenerProcedureIdApertura());

		// Creamos el trámite de apertura para el expediente
		TramiteAperturas tramiteApertura = new TramiteAperturas();
		tramiteApertura
				.setNumRegistro062(contextSubmission.getRegistryNumber());
		try {
			tramiteApertura.setFecRegistro062(
					Utilities.getInstance().stringToDatePlatea(
							contextSubmission.getRegistryTimestamp()));
		} catch (Exception e) {
			ManejadorTareasAperturas.LOGGER.error(
					"[ERROR] : Fallo en generarYObtenerIdTramiteYTareaAportacion: contextSubmission.getRegistryTimestamp()");
		}
		tramiteApertura.setTipoTramite(tipoTramiteApertura);
		tramiteApertura.setApertura(apertura);
		tramiteApertura = this.tramiteAperturasService.add(tramiteApertura);

		// Obtenemos el tipo de trámite de apertura

		String tipotareaflujo = TipoTareaFlujo.APORTACION_DOCUMENTACION
				.getTaskId();
		if (ConstantesPlateaTramitacion.SUBMISSIONTYPE_APORT_SUBSANA
				.equals(contextSubmission.getSubmissionType())) {
			tipotareaflujo = TipoTareaFlujo.SUBSANACION.getTaskId();
		}

		Tarea tipoTarea = this.tareaService.findByTaskIdProcedureId(
				tipotareaflujo,
				Utilities.getInstance().obtenerProcedureIdApertura());

		this.crearTareaEjecutada(tipoTarea, tramiteApertura, contextSubmission);

		return tramiteApertura.getIdTramite062();
	}

	/**
	 * Crear tarea ejecutada.
	 * 
	 * tipoTarea the tipo tarea tramite the tramite contextSubmission the
	 * context submission the tarea procedimiento
	 *
	 * @param tipoTarea
	 *            the tipo tarea
	 * @param tramite
	 *            the tramite
	 * @param contextSubmission
	 *            the context submission
	 * @return the tarea procedimiento
	 */
	private TareaProcedimiento crearTareaEjecutada(Tarea tipoTarea,
			TramiteProcedimiento tramite,
			ContextSubmissionEvent contextSubmission) {

		ComunicacionApertura apertura = this
				.findExpedienteByFolderId(contextSubmission.getFolderID());

		TareaAperturas tarea = new TareaAperturas();
		tarea.setTramiteAperturas((TramiteAperturas) tramite);
		tarea.setMailboxTaskId063("NO ES TAREA PLATEA");
		tarea.setTipoTarea(tipoTarea);
		tarea.setEstado063(EstadosTareas.EJECUTADA.getEstado());
		tarea.setFechaIni063(new Date());
		tarea.setFechaFin063(new Date());
		tarea.setUsuario063(apertura.getUsuarioAport());

		tarea = this.tareaAperturasService.add(tarea);

		return tarea;

	}

	/**
	 * Copiar docs R 02 G.
	 * 
	 * idApe Integer List<DocumentoAperturas>
	 * 
	 * @param idApe
	 *            the id ape the list
	 * @return the list
	 * @throws AB04BException
	 *             producida al copiar los documentos en PIF
	 */
	protected List<DocumentoAperturas> copiarDocsT65e(Long idApe)
			throws AB04BException {
		DocumentoAperturas docFilter = new DocumentoAperturas();
		docFilter.setIdapetemp065(idApe);
		List<DocumentoAperturas> listaDocumentos = this.documentoAperturasService
				.buscarDocumentosAperturasTempIdApe(docFilter);

		for (DocumentoAperturas doc : listaDocumentos) {
			// Lo copiamos a /t65e
			if (doc.getRutaPif065() != null) {
				String rutaDestino = this.appConfiguration
						.getProperty(PropertiesUtil.PIF_RUTA_PIF_DOKUSI)
						.concat(doc.getRutaPif065());

				String rutapif = this.pifService.copyDocument(
						doc.getRutaPif065(), rutaDestino.toLowerCase(), true);
				doc.setRutaPif065(rutapif);
			}
		}

		return listaDocumentos;
	}

}
